/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.ppcore.transform;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.porpit.ppcore.transform.Transformer;
import com.porpit.ppcore.transform.TransformerNames;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class PPCoreTransformer
implements IClassTransformer {
    private final ArrayList<Transformer> transformers = new ArrayList();

    public PPCoreTransformer() {
        this.initTransformers();
    }

    protected abstract void initTransformers();

    protected void addTransformer(Transformer transformer) {
        this.transformers.add(transformer);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.contains("com.porpit")) {
            return basicClass;
        }
        return this.transform(transformedName, basicClass);
    }

    public byte[] transform(String name, byte[] basicClass) {
        for (int i = 0; i < this.transformers.size(); ++i) {
            if (!this.transformers.get(i).is(name)) continue;
            System.out.println("[ppcore] Patching " + this.transformers.get((int)i).className + "");
            byte[] classData = this.transformers.get(i).transform(basicClass);
            ClassReader reader = new ClassReader(classData);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static byte[] spliceClasses(byte[] data, String className, String ... methods) {
        ClassReader reader = new ClassReader(data);
        ClassNode nodeOrig = new ClassNode();
        reader.accept((ClassVisitor)nodeOrig, 0);
        ClassNode nodeNew = PPCoreTransformer.spliceClasses(nodeOrig, className, methods);
        ClassWriter writer = new ClassWriter(0);
        nodeNew.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static ClassNode getClassNode(Class cl, String className) {
        try {
            ClassNode classNode = new ClassNode();
            String tfClassName = TransformerNames.patchClassName(className);
            InputStream stream = cl.getClassLoader().getResourceAsStream(tfClassName.replace('.', '/') + ".class");
            ClassReader classReader = new ClassReader(ByteStreams.toByteArray((InputStream)stream));
            classReader.accept((ClassVisitor)classNode, 0);
            return classNode;
        }
        catch (IOException e) {
            System.out.println("faild to load:" + className);
        }
        catch (NullPointerException e) {
            System.out.println("class:" + className + " not found");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassNode spliceClasses(ClassNode data, String className, String ... methods) {
        try (InputStream stream = PPCoreTransformer.class.getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");){
            ClassNode classNode = PPCoreTransformer.spliceClasses(data, ByteStreams.toByteArray((InputStream)stream), className, methods);
            return classNode;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassNode spliceClasses(ClassNode nodeData, byte[] dataSplice, String className, String ... methods) {
        int i;
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found!");
        }
        HashSet methodSet = Sets.newHashSet((Object[])methods);
        ArrayList methodList = Lists.newArrayList((Object[])methods);
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept((ClassVisitor)new ClassRemapper((ClassVisitor)nodeSplice, remapper), 8);
        for (String s : nodeSplice.interfaces) {
            if (!methodSet.contains(s)) continue;
            nodeData.interfaces.add(s);
            System.out.println("Added INTERFACE: " + s);
        }
        for (i = 0; i < nodeSplice.methods.size(); ++i) {
            for (int k = 0; k < methodSet.size(); ++k) {
            }
            if (!methodSet.contains(((MethodNode)nodeSplice.methods.get((int)i)).name)) continue;
            MethodNode mn = (MethodNode)nodeSplice.methods.get(i);
            String srgName = (String)methodList.get(methodList.indexOf(mn.name) & 0xFFFFFFFE);
            String notchName = Transformer.patchMethodName(targetClassName2, srgName, mn.desc);
            String notchDesc = Transformer.patchDESC(mn.desc);
            boolean added = false;
            mn.name = notchName;
            mn.desc = notchDesc;
            for (int j = 0; j < nodeData.methods.size(); ++j) {
                if (!((MethodNode)nodeData.methods.get((int)j)).name.equals(mn.name) || !((MethodNode)nodeData.methods.get((int)j)).desc.equals(mn.desc)) continue;
                MethodNode oldMn = (MethodNode)nodeData.methods.get(j);
                System.out.println("Spliced in METHOD: " + targetClassName + "." + mn.name);
                nodeData.methods.set(j, mn);
                if (nodeData.superName != null && nodeData.name.equals(nodeSplice.superName)) {
                    for (AbstractInsnNode node : mn.instructions) {
                        if (!(node instanceof MethodInsnNode) || node.getOpcode() != 183) continue;
                        MethodInsnNode methodNode = (MethodInsnNode)node;
                        if (!targetClassName2.equals(methodNode.owner)) continue;
                        methodNode.owner = nodeData.superName;
                    }
                }
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added METHOD: " + targetClassName + "." + mn.name);
            nodeData.methods.add(mn);
            added = true;
        }
        for (i = 0; i < nodeSplice.fields.size(); ++i) {
            if (!methodSet.contains(((FieldNode)nodeSplice.fields.get((int)i)).name)) continue;
            FieldNode mn = (FieldNode)nodeSplice.fields.get(i);
            boolean added = false;
            for (int j = 0; j < nodeData.fields.size(); ++j) {
                if (!((FieldNode)nodeData.fields.get((int)j)).name.equals(mn.name) || !((FieldNode)nodeData.fields.get((int)j)).desc.equals(mn.desc)) continue;
                System.out.println("Spliced in FIELD: " + targetClassName + "." + mn.name);
                nodeData.fields.set(j, mn);
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added FIELD: " + targetClassName + "." + mn.name);
            nodeData.fields.add(mn);
            added = true;
        }
        return nodeData;
    }
}

